/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.common.config.GiveMode;
import mezz.jei.common.config.IClientConfig;
import mezz.jei.common.config.IngredientSortStage;
import mezz.jei.common.config.file.IConfigCategoryBuilder;
import mezz.jei.common.config.file.IConfigSchemaBuilder;
import mezz.jei.common.config.file.serializers.EnumSerializer;
import mezz.jei.common.config.file.serializers.ListSerializer;
import mezz.jei.common.platform.Services;
import org.jetbrains.annotations.Nullable;

public final class ClientConfig
implements IClientConfig {
    @Nullable
    private static IClientConfig instance;
    private final Supplier<Boolean> centerSearchBarEnabled;
    private final Supplier<Integer> maxRecipeGuiHeight;
    private final Supplier<GiveMode> giveMode;
    private final Supplier<Boolean> cheatToHotbarUsingHotkeysEnabled;
    private final Supplier<Boolean> addBookmarksToFrontEnabled;
    private final Supplier<Boolean> dragToRearrangeBookmarksEnabled;
    private final Supplier<Boolean> lowMemorySlowSearchEnabled;
    private final Supplier<Boolean> catchRenderErrorsEnabled;
    private final Supplier<Boolean> lookupFluidContentsEnabled;
    private final Supplier<Integer> dragDelayMs;
    private final Supplier<List<IngredientSortStage>> ingredientSorterStages;
    private final Supplier<Boolean> hideSingleIngredientTagsEnabled;

    public ClientConfig(IConfigSchemaBuilder schema) {
        instance = this;
        boolean isDev = Services.PLATFORM.getModHelper().isInDev();
        IConfigCategoryBuilder appearance = schema.addCategory("appearance");
        this.centerSearchBarEnabled = appearance.addBoolean("CenterSearch", false, "Move the JEI search bar to the bottom center of the screen.");
        this.maxRecipeGuiHeight = appearance.addInteger("RecipeGuiHeight", 350, 175, Integer.MAX_VALUE, "Max recipe GUI height.");
        IConfigCategoryBuilder cheatMode = schema.addCategory("cheat_mode");
        this.giveMode = cheatMode.addEnum("GiveMode", GiveMode.defaultGiveMode, "Choose if JEI should give ingredients directly to the inventory or pick them up with the mouse.");
        this.cheatToHotbarUsingHotkeysEnabled = cheatMode.addBoolean("CheatToHotbarUsingHotkeysEnabled", false, "Enable cheating items into the hotbar by using Shift + numeric keys.");
        IConfigCategoryBuilder bookmarks = schema.addCategory("bookmarks");
        this.addBookmarksToFrontEnabled = bookmarks.addBoolean("AddBookmarksToFrontEnabled", false, "Add new bookmarks to the front of the bookmark list instead of the end.");
        this.dragToRearrangeBookmarksEnabled = bookmarks.addBoolean("DragToRearrangeBookmarksEnabled", true, "Drag bookmarks to rearrange them in the list.");
        IConfigCategoryBuilder advanced = schema.addCategory("advanced");
        this.lowMemorySlowSearchEnabled = advanced.addBoolean("LowMemorySlowSearchEnabled", false, "Set low-memory mode (makes search very slow but uses less RAM).");
        this.catchRenderErrorsEnabled = advanced.addBoolean("CatchRenderErrorsEnabled", !isDev, "Catch render errors from ingredients and attempt to recover from them instead of crashing.");
        this.lookupFluidContentsEnabled = advanced.addBoolean("lookupFluidContentsEnabled", false, "When looking up recipes with items that contain fluids, also look up recipes for the fluids.");
        IConfigCategoryBuilder input = schema.addCategory("input");
        this.dragDelayMs = input.addInteger("dragDelayInMilliseconds", 150, 0, 1000, "Number of milliseconds before a long mouse click is considered a drag operation.");
        IConfigCategoryBuilder sorting = schema.addCategory("sorting");
        this.ingredientSorterStages = sorting.addList("IngredientSortStages", IngredientSortStage.defaultStages, new ListSerializer<IngredientSortStage>(new EnumSerializer<IngredientSortStage>(IngredientSortStage.class)), "Sorting order for the ingredient list.");
        IConfigCategoryBuilder tags = schema.addCategory("tags");
        this.hideSingleIngredientTagsEnabled = tags.addBoolean("HideSingleIngredientTagsEnabled", true, "Hide tags that only have 1 ingredient.");
    }

    @Deprecated
    public static IClientConfig getInstance() {
        Preconditions.checkNotNull((Object)instance);
        return instance;
    }

    @Override
    public boolean isCenterSearchBarEnabled() {
        return this.centerSearchBarEnabled.get();
    }

    @Override
    public boolean isLowMemorySlowSearchEnabled() {
        return this.lowMemorySlowSearchEnabled.get();
    }

    @Override
    public boolean isCatchRenderErrorsEnabled() {
        return this.catchRenderErrorsEnabled.get();
    }

    @Override
    public boolean isCheatToHotbarUsingHotkeysEnabled() {
        return this.cheatToHotbarUsingHotkeysEnabled.get();
    }

    @Override
    public boolean isAddingBookmarksToFrontEnabled() {
        return this.addBookmarksToFrontEnabled.get();
    }

    @Override
    public boolean isLookupFluidContentsEnabled() {
        return this.lookupFluidContentsEnabled.get();
    }

    @Override
    public GiveMode getGiveMode() {
        return this.giveMode.get();
    }

    @Override
    public boolean isDragToRearrangeBookmarksEnabled() {
        return this.dragToRearrangeBookmarksEnabled.get();
    }

    @Override
    public int getDragDelayMs() {
        return this.dragDelayMs.get();
    }

    @Override
    public int getMaxRecipeGuiHeight() {
        return this.maxRecipeGuiHeight.get();
    }

    @Override
    public List<IngredientSortStage> getIngredientSorterStages() {
        return this.ingredientSorterStages.get();
    }

    @Override
    public boolean isHideSingleIngredientTagsEnabled() {
        return this.hideSingleIngredientTagsEnabled.get();
    }
}

